// scripts.js - interaksi ringan: toggle nav, load more (demo)
document.addEventListener('DOMContentLoaded', function () {
  const navToggle = document.getElementById('navToggle');
  const siteNav = document.getElementById('siteNav');

  navToggle.addEventListener('click', () => {
    const expanded = navToggle.getAttribute('aria-expanded') === 'true';
    navToggle.setAttribute('aria-expanded', String(!expanded));
    const isVisible = siteNav.style.display === 'block';
    siteNav.style.display = isVisible ? '' : 'block';
    siteNav.setAttribute('aria-hidden', String(isVisible));
  });

  const loadBtn = document.getElementById('loadMore');
  if (loadBtn) {
    loadBtn.addEventListener('click', () => {
      const ul = document.querySelector('.news-list');
      for (let i=0;i<2;i++){
        const li = document.createElement('li');
        li.className = 'news-item';
        li.innerHTML = `
          <img src="assets/placeholder-3.jpg" alt="More"/>
          <div>
            <h4>Posting Tambahan</h4>
            <time datetime="${new Date().toISOString().slice(0,10)}">${new Date().toLocaleDateString()}</time>
            <p>Contoh tambahan berita (dummy) untuk demonstrasi.</p>
          </div>
        `;
        ul.appendChild(li);
      }
    });
  }
});